
//#pragma pack(4)

#define _AMD64_


//
// command definitions
#define WH32_COMMAND_FEDERAL_ONLY 0
#define WH32_COMMAND_FEDERAL_AND_STATE 1
#define WH32_COMMAND_FEDERAL_EMPLOYER_FICA_MEDICARE 2

#define WH32_COMMAND_GROSSUP_REGULAR 11
#define WH32_COMMAND_GROSSUP_SUPPLEMENTAL 12


struct MDATE{
  long month;
  long day;
  long year;
};



//
// master error return values
#define WH32_RETURN_FEDERAL_ERROR 1
#define WH32_RETURN_FICA_ERROR 2
#define WH32_RETURN_MEDICARE_ERROR 4
#define WH32_RETURN_STATE_ERROR 8
#define WH32_RETURN_COUNTY_ERROR 16
#define WH32_RETURN_LOCAL_ERROR 16
#define WH32_RETURN_CITY_ERROR 32
#define WH32_RETURN_SUPPLEMENTAL_ERROR 64;


//
// state definitions
#define WH32_ALABAMA 1
#define WH32_ALASKA  2
#define WH32_AMERICANSAMOA 3
#define WH32_ARIZONA 4
#define WH32_ARKANSAS 5
#define WH32_CALIFORNIA 6
#define WH32_COLORADO 7
#define WH32_CONNECTICUT  8
#define WH32_DELAWARE  9
#define WH32_DISTRICTOFCOLUMBIA 10
#define WH32_FEDERATEDSTATESOFMICRONESIA  11
#define WH32_FLORIDA 12
#define WH32_GEORGIA 13
#define WH32_GUAM 14
#define WH32_HAWAII 15
#define WH32_IDAHO 16
#define WH32_ILLINOIS  17
#define WH32_INDIANA 18
#define WH32_IOWA 19
#define WH32_KANSAS 20
#define WH32_KENTUCKY 21
#define WH32_LOUISIANA 22
#define WH32_MAINE 23
#define WH32_MARSHALLISLANDS 24
#define WH32_MARYLAND 25
#define WH32_MASSACHUSETTS 26
#define WH32_MICHIGAN 27
#define WH32_MINNESOTA 28
#define WH32_MISSISSIPPI 29
#define WH32_MISSOURI 30
#define WH32_MONTANA 31
#define WH32_NEBRASKA 32
#define WH32_NEVADA 33
#define WH32_NEWHAMPSHIRE 34
#define WH32_NEWJERSEY 35
#define WH32_NEWMEXICO 36
#define WH32_NEWYORK 37
#define WH32_NORTHCAROLINA 38
#define WH32_NORTHDAKOTA 39
#define WH32_NORTHERNMARIANAISLANDS 40
#define WH32_OHIO 41
#define WH32_OKLAHOMA 42
#define WH32_OREGON 43
#define WH32_PALAU 44
#define WH32_PENNSYLVANIA 45
#define WH32_PUERTORICO 46
#define WH32_RHODEISLAND 47
#define WH32_SOUTHCAROLINA 48
#define WH32_SOUTHDAKOTA 49
#define WH32_TENNESSEE 50
#define WH32_TEXAS 51
#define WH32_UTAH 52
#define WH32_VERMONT 53
#define WH32_VIRGINISLANDS 54
#define WH32_VIRGINIA 55
#define WH32_WASHINGTON 56
#define WH32_WESTVIRGINIA 57
#define WH32_WISCONSIN 58
#define WH32_WYOMING 59



//
// federal_error definitions
#define WH32_FEDERAL_NOTABLE 1
#define WH32_FEDERAL_STRUCT_ERROR 2
#define WH32_FEDERAL_ILLEGAL_PERIOD 3
#define WH32_GROSSUP_DID_NOT_CONVERGE 100;

//
// federal status
#define FEDERAL_STATUS_SINGLE 0
#define FEDERAL_STATUS_MARRIED 1
#define FEDERAL_STATUS_HEADOFHOUSEHOLD 2
#define FEDERAL_STATUS_MARRIED_WITHHOLD_AS_SINGLE 3
#define FEDERAL_STATUS_MARRIED_FILING_SEPARATELY 3

//
// federal supplemental options
#define FEDERAL_SUPPLEMENTAL_FLAT_CALCULATION 0
#define FEDERAL_SUPPLEMENTAL_ADD_TO_SALARY 1


//
// fica eligibility
#define FEDERAL_FICA_ELIGIBLE 0
#define FEDERAL_FICA_EXEMPT 1

//
// medicare eligibility
#define FEDERAL_MEDICARE_ELIGIBLE 0
#define FEDERAL_MEDICARE_EXEMPT 1

//
// federal withholding exempt status
#define FEDERAL_WITHHOLD_ELIGIBLE 0
#define FEDERAL_WITHHOLD_EXEMPT 1


//
// 
struct WITHHOLDING_IL_STRUC{
	long struct_size;
	long exemptions;
};



#ifndef __GNUC__
#pragma pack(4)
#endif
//
struct FEDERAL_WITHHOLDING_STRUC{
  long	struct_size;
  long  dummy;

  long	federal_error;
  long	federal_exemptions;
  MDATE	federal_table_date;
  long  federal_table;
  long  federal_period;
  double federal_taxable_pay;

  double federal_additional_withholding;
  
  MDATE table_used;
  double federal_withhold_amount;

  // federal social security info
  long	fica_error;
  long	fica_exempt;
  double federal_ficamedicare_pay;
  double	previous_fica_wages_this_year;
  double fica_withhold_amount;

  // federal medicare info
  long  medicare_error;
  long	medicare_exempt;
  double	previous_medicare_wages_this_year;
  double medicare_withhold_amount;

  // supplemental income info
  double supplemental_amount;
  double ytd_supplemental_amount;
  long supplemental_calc_type;
  long supplemental_tax_type;
  double supplemental_tax;

  long withhold_exempt;
  
  long w4_2020;         //(0 = no new w4, 1 = new w4 submitted)
  long w4_2020_step2;   //(0 = no, 1= checked on w4)
  double w4_2020_step3;
  double w4_2020_step4a;
  double w4_2020_step4b;
 //note: w4_2020_stpe4c is federal_additional_withholding in original structure above
  long w4_2020_nra;     //(0 = no, 1 = yes) //length to here 288 bytes

  double marginal_rate; //last dollar rate from 2020.9
  
  

};

#define W4_2020_2JOB_FLAG 1 // set w4_2020_step2 to this if check box set in 2020 w4


//
// state_error definitions
#define WH32_STATE_NOTABLE 1
#define WH32_ARIZONA_ILLEGALPERCENT 2
#define WH32_STATE_NOSTATE 3
#define WH32_STATE_STRUCT_ERROR 4


//
// state status
#define STATE_STATUS_SINGLE 0
#define STATE_STATUS_MARRIED 1
#define STATE_STATUS_HEADOFHOUSEHOLD 2
#define STATE_STATUS_MARRIEDSEPERATE 3
#define STATE_STATUS_MARRIEDSEPARATE 3  //for the grammar police

#define STATE_STATUS_MARRIED_ONE_WORKING 4		// GEORGIA 
#define STATE_STATUS_MARRIED_BOTH_WORKING 5		// GEORGIA & maine
#define STATE_STATUS_QUALIFYINGWIDOWER 6		// NEW JERSEY
#define STATE_STATUS_SURVIVINGSPOUSE 7		// nebraska
#define STATE_STATUS_NONE 8				// alabama
#define STATE_STATUS_MARRIED_SELF_ONLY 9	// ARKANSAS
#define STATE_STATUS_MARRIED_FILING_SINGLE 10  //introduced for Oregon in 2011
#define STATE_STATUS_MARRIED_BOTH_WORKING_LOW_STANDARD_DEDUCTION 11 // introducted GA 2012.09
#define STATE_STATUS_MARRIED_WITHHOLD_SINGLE 12  //Hawaii Idaho MAINE VERMONT
#define STATE_STATUS_CERTIFIED_DISABLED 13
#define STATE_STATUS_NONRESIDENT_MILITARY_SPOUSE 14
#define STATE_STATUS_NOEXEMPTION 15  // Louisiana


//
// state supplemental options
#define STATE_SUPPLEMENTAL_FLAT_CALCULATION 0
#define STATE_SUPPLEMENTAL_ADD_TO_SALARY 1

//
// type of supplemental tax to apply
#define STATE_SUPPLEMENTAL_CA_BONUS_STOCK 0
#define STATE_SUPPLEMENTAL_CA_OTHER 1

// West Virginia special_field_1 options
// LOW_RATE means one working or one job
#define LOW_RATE 0
#define REGULAR RATE 1

//
// county error definitions
#define WH32_COUNTY_NOTABLE 1

//
// local error definitions
#define	WH32_LOCAL_NOTABLE 1


#ifndef __GNUC__
#pragma pack(4)
#endif

struct STATE_WITHHOLDING_STRUC{
  long  struct_size;
  long	state_error;
  long	state_number;
  long  state_allowances;	
  long  state_table;
  long  state_period;
  double  state_taxable_pay;
  double state_additional_withholding;
  MDATE	table_used;

  double state_withhold_amount;

  double arizona_withhold_percentage;
  long california_estimated_deductions;		// de-4 line 2
  long michigan_special_exemptions;			// mi-w4 line 13
  long michigan_claim_as_dependent;			// mi-w4 line 14
  long connecticut_filing_status;			// ct-w4 line 1
  double connecticut_reductional_amount;	// ct-w4 line 3
  long georgia_dependents;					// g-4 line 5b (5a is state_exemptions)
  long louisiana_dependents;				// l-4 line 7
  long massachusetts_headofhousehold;		// box a
  long massachusetts_blind;					// box b
  long massachusetts_spouse_blind;			// box c
  long massachusetts_student;				// box d
  long newjersey_table;						// w4 line 3
  long alabama_dependents;					// a4 line 3
  double mississippi_exemption_amount;		// line 6
  long special_field_1;                     // previously arkansas_low_income_qualified;		// ar4ec line 5
  long illinois_additional_allowances;					// ilw4 line 2
  long indiana_dependents;

  double supplemental_amount;
  double ytd_supplemental_amount;
  long supplemental_calc_type;
  long supplemental_tax_type;				// used for California
  double supplemental_tax;

  long pr_r4_parta_option;                  // see parta options in wh32.h
  long pr_r4_partb;                         // number of dependents
  long veterans_deduction;//pr_r4_partc_method; // anything >0 will cause veterans deduction to be applied
  long pr_r4_partc_allowance;				// for optional method number of allowances
  double unused2; //pr_r4_partc_public_retire_amount;  // public penson or retirement system amount (pay period)
  long unused3;//pr_r4_partd;							// tax calculation type  (not used, use state_additional_withholding)
   
  // below 2011.06
  double special_field_2;
  
  // 2020 
  long stw4l1;
  long stw4l2;
  long stw4l3;
  long stw4l4;
  double stw4d1;
  double stw4d2;
  double stw4d3;
  double stw4d4; // 400 bytes through here

  double marginal_rate; // added 2020.9

};

struct COUNTY_WITHHOLDING_STRUC{
	long struct_size;
	long county_error;
	long county_number;
	long county_allowances;
	long county_table;
	long county_period;
	double county_taxable_pay;
	double county_additional_withholding;
	MDATE table_used;
	double county_withhold_amount;
	long indiana_resident;
	double percent_amount;
	double maximum;
	double year_to_date_withholding;
	long number_of_exemptions;
	double exemption_amount;
	double allowance_amount;
	double annual_opt;
	long	residence_number;
    union {
        double residence_withhold_amount;
        double employer_amount;
    };
    long   muni_type;

    double supplemental_amount;
	double ytd_supplemental_amount;
    long supplemental_calc_type;
    long supplemental_tax_type;				// used for California
    double supplemental_tax;
	double supplemental_residence_tax;      //effective 2013.09
    double marginal_rate; //last dollar rate from 2020.9


};

struct LOCAL_WITHHOLDING_STRUC{
	long struct_size;
	long error;
	long id_number;
	long allowances;
	long table;
	long period;
	double taxable_pay;
	double additional_withholding;
	MDATE table_used;
	double withhold_amount;
	long resident;
	double percent_amount;
	double maximum;
	double year_to_date; //for local this is previous ytd INCOME
	long number_of_exemptions;
	double exemption_amount;
	double fixed_allowance_amount;
	double annual_opt;
	long	residence_number;
    union {
        double residence_withhold_amount;
        double employer_amount;
    };
    long   muni_type;

    double supplemental_amount;
	double ytd_supplemental_amount;
    long supplemental_calc_type;
    long supplemental_tax_type;				// used for California
    double supplemental_tax;
	double supplemental_residence_tax;      //effective 2013.09
    double marginal_rate; //last dollar rate from 2020.9

};


struct WITHHOLDING_TAXBODY_INFO{
  long struct_size;
  long error;
  long state;
  long muni_type;
  long prompt_number;
  long desired_entry;      /*set by calling program, return info on this name*/
  long number_of_entries;  /*returned by function*/
  long muni_number;        /*returned by function if non-zero, used by state and present to customer*/
  long calc_number;        /*returned by function;  application uses this number in calls to
						                            calculation function*/
};


struct FEDERAL_TABLE{
  MDATE start_period;
  MDATE end_period;
  long table;
  long period;
  double exemption_amount;
  double bracketlow;
  double brackethigh;
  double amount;
  double pluspercent;
};


struct GENERAL_STATE_TABLE{
  MDATE start_period;
  MDATE end_period;
  long table;
  long period;
  double exemption_amount;
  double bracketlow;
  double brackethigh;
  double amount;
  double pluspercent;

};



#define WH32_GET_TABLE_INFO_NO_ERROR 0
#define WH32_GET_TABLE_INFO_INVALID_COMMAND 1
#define WH32_GET_TABLE_INFO_INVALID_DATE 2

#define WH32_TABLE_INFO_COMMAND_GET_FICA_MAX 1

struct WH32_TABLE_INFO{
  long struct_size;      // set by calling app 
  MDATE date;            // set by calling app
  long command;			 // set by calling app
  double value;			 // value returned by app
};







//
// definitions for local withholding 'id_number' follow
//



/*MISSOURI LOCAL TAXING DISTRICTS*/
#define WH32_MO_NONE 0
#define WH32_MO_STLOUIS 1
#define WH32_MO_KANSASCITY 2


#define OH_SCHOOL_DISTRICT_TAX 0
#define OH_MUNICIPAL_TAX 1





//INDIANA COUNTIES
#define INDIANA_COUNTY_RESIDENT 1






//PENNSYLVANIA LOCAL TAXING DISTRICTS
#define PA_LOCAL_OPT_PAYPERIOD  0
#define PA_LOCAL_OPT_ANNUAL 1
#define PA_LOCAL_OPT_NONE 2

// PA muni_type field
#define PA_LOCAL_SCHOOL 0
#define PA_LOCAL_SCHOOL_EIT 10
#define PA_LOCAL_SCHOOL_LST 11

#define PA_LOCAL_MUNICIPAL 1
#define PA_LOCAL_MUNICIPAL_EIT 20
#define PA_LOCAL_MUNICIPAL_LST 21

#define LOCAL_RESIDENT 1
#define LOCAL_NONRESIDENT 0



// PUERTO RICO MACROS
// part a
#define PR_SINGLE_FULL 0
#define PR_SINGLE_NONE 1
#define PR_MARRIED_SEPARATE_FULL 2
#define PR_MARRIED_SEPARATE_NONE 3
#define PR_MARRIED_FULL 4
#define PR_MARRIED_HALF 5
#define PR_MARRIED_NONE 6
#define PR_HEAD_OF_HOUSEHOLD_FULL 7
#define PR_HEAD_OF_HOUSEHOLD_NONE 8


#define PR_R4_PARTC_COMPLETE 0
#define PR_R4_PARTC_NONE 1
#define PR_R4_PARTC_OPTIONAL 2

#define PR_R4_PARTD_AUTO 0
#define PR_R4_PARTD_OPTIONAL 1

//
// Kentucky local withholding
//
// PA muni_type field
#define KY_LOCAL_SCHOOL 0
#define KY_LOCAL_CITY 1
#define KY_LOCAL_COUNTY 2

//
// MAINE nonresident alien
//
#define MAINE_NONRESIDENT_ALIEN 99


