
#define WH32_FEDERAL 0
#define WH32_CANADA_NEWFOUNDLAND 1
#define WH32_CANADA_LABRADOR 2
#define WH32_CANADA_NOVA_SCOTIA 3
#define WH32_CANADA_PRINCE_EDWARD_ISLAND 4
#define WH32_CANADA_NEW_BRUNSWICK 5
#define WH32_CANADA_QUEBEC 6
#define WH32_CANADA_ONTARIO 7
#define WH32_CANADA_MANITOBA 8
#define WH32_CANADA_SASKATCHEWAN 9
#define WH32_CANADA_ALBERTA 10
#define WH32_CANADA_BRITISH_COLUMBIA 11
#define WH32_CANADA_YUKON 12
#define WH32_CANADA_NORTHWEST_TERRITORIES 13
#define WH32_CANADA_NUNAVUT	14

struct CANADA_CLAIM_CODE_STRUC{
  long	struct_size;
  MDATE	table_date;
  long	error;
  long province_id;
  long  desired_claim_code;
  double claim_code_lower;   // returned by function
  double claim_code_higher;  // returned by function
  double claim_code_midpoint; // returned by function (80)

  double netincome;          // input
};


struct CANADA_FEDERAL_WITHHOLDING_STRUC{
  long	struct_size;
  MDATE	federal_table_date;

  long	error;
  long period;

  /* td1 information*/
  double claim_amount;
  double prescribed_zone_deduct;
  double additional;
  long resident;
  long	canada_90_percent;
  long	income_less_than_claim;

  /*other information*/
  double labor_sponsored_corporation_deduction;
  double other_federal_credits;  /*k3 */

  /* federal taxable income */
  double taxable_income;


  /* ccp information */
  double ccp_taxable_income;
  double ccp_year_to_date;
  long	ccp_eligible_months;


  /* employment insurance information*/
  double ei_taxable_income;
  double ei_year_to_date;

  /*information return*/
  double annual_withhold_amount;

  /* results */
  double withhold_amount;
  double ccp_withhold_amount;
  double ei_withhold_amount;

  double dummy;
// length to this point 160 bytes
  double withhold_amount_pp_fedonly;

  double current_taxable_bonus;
  double previous_taxable_bonus;
  double bonus_withhold_amount;
  double bonus_ccp_withhold_amount;
  double bonus_ei_withhold_amount;
// length to this point is 208 bytes
  double provincially_registered_LSVCC;
};



struct CANADA_PROVINCIAL_WITHHOLDING_STRUC{

  long	struct_size;
  MDATE	table_date;

  long	error;

  long province_id;
  long period;

  /* td1 information*/
  double claim_amount;
  double additional;
  long resident;
  long disabled_dependents; /*ontario*/
  long dependents_under_18; /* or equal to 18 ontario*/
  long notused2;
  long notused3;
  long notused4;
  double prescribed_zone_deduct;


    /*other information*/
  double labor_sponsored_corporation_deduction;
  double other_provincial_credits;

  /* taxable income */
  double taxable_income;


  double annual_withhold_amount;

  double dummy;

//length to this point 116 bytes

  double current_taxable_bonus;
  double previous_taxable_bonus;
  double bonus_withhold_amount;

};


struct CANADA_PROVINCIAL_WITHHOLDINGY_STRUC{
  double federal_labor_sponsored_corporation_deduction;
  double ccp_withhold_amount;
  double ei_withhold_amount;
  double withhold_amount;

};


struct CANADA_QUEBEC_WITHHOLDING_STRUC{
  long	struct_size;
  MDATE	table_date;
  long  error;
  double rpp;
  double rrsp;
  double tp1015_3_V_amount; // line 19 of form tp-1015.3-V
  double nf_tax_credits; //K1 from tax instructions
  double indexed_personal_tax_credit; // from tp-1015.3-V  line 7
  double nonindexed_personal_tax_credit; // from tp-10155.3-V line 9
  double class_a_class_b;
  long class_a_b_periods;
  double taxable_income;
  double bonus;				 // used for bonus
  double bonus_ytd;			 // used for bonus
  double deductions;
  double additional_withholding;
  long period;
  long period_remaining;
  double withhold_amount;
  double dummy;
  double class_a_class_b_fondaction; 
  long class_a_b_fondaction_periods;
  double foreign_employee_deduction; /*beginning in 2013*/
  double health_premium_ytd;
  double health_premium_withhold;


};


#define CLAIM_YES 1
#define CLAIM_NO 0

#define CANADA_RESIDENT 1
#define CANADA_NONRESIDENT 0

#define CANADA_INCOME_LESS_THAN_CLAIM 1
